import { API_URL, VERSION_NUMBER } from '../lib/constants.js';

/**
 * 检查服务器插件版本不一致的话提醒更新
 * @returns {Promise<boolean>}
 */
export async function versionCheck() {
    try {
        // 获取上次检查时间
        const { lastCheckTime } = await chrome.storage.local.get('lastCheckTime');
        const now = new Date().getTime();

        // 如果距离上次检查不足24小时，使用缓存的结果
        if (lastCheckTime && (now - lastCheckTime) < 24 * 60 * 60 * 1000) {
            const { cachedVersionMismatch } = await chrome.storage.local.get('cachedVersionMismatch');
            return cachedVersionMismatch || false;
        }

        const response = await fetch(API_URL + '/api/app/v1/api-info');
        if (!response.ok) {
            throw new Error('版本检查请求失败');
        }

        const { data } = await response.json();
        const versionMismatch = data.plugin !== VERSION_NUMBER;

        // 更新检查时间和缓存结果
        await chrome.storage.local.set({
            lastCheckTime: now,
            cachedVersionMismatch: versionMismatch
        });

        return versionMismatch;
    } catch (error) {
        console.error('版本检查失败:', error);
        return false; // 出错时默认返回 false，避免误报
    }
}